/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.ErrorUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.SwingUtils;

public class PrivatePackDialog
extends JDialog {
    private JEditorPane editorPane;
    private JTextField modpackName;
    private JButton remove;
    private JButton add;
    private JButton cancel;

    public PrivatePackDialog() {
        super((Frame)LaunchFrame.getInstance(), false);
        this.setupGui();
        this.getRootPane().setDefaultButton(this.add);
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PrivatePackDialog.this.modpackName.getText().isEmpty() && DownloadUtils.staticFileExists(PrivatePackDialog.this.modpackName.getText() + ".xml")) {
                    if (!Settings.getSettings().getPrivatePacks().contains(PrivatePackDialog.this.modpackName.getText())) {
                        Logger.logInfo("Adding: " + PrivatePackDialog.this.modpackName.getText());
                        ModPack.loadXml(PrivatePackDialog.this.modpackName.getText() + ".xml");
                        Settings.getSettings().addPrivatePack(PrivatePackDialog.this.modpackName.getText());
                        Settings.getSettings().save();
                        PrivatePackDialog.this.setVisible(false);
                    } else {
                        ErrorUtils.tossError(I18N.getLocaleString("PRIVATEPACK_ALREADY_ADDED"));
                    }
                } else {
                    ErrorUtils.tossError(I18N.getLocaleString("PRIVATEPACK_ERROR"));
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivatePackDialog.this.setVisible(false);
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ArrayList<String> codes = Settings.getSettings().getPrivatePacks();
                if (codes.contains(PrivatePackDialog.this.modpackName.getText())) {
                    Settings.getSettings().removePrivatePack(PrivatePackDialog.this.modpackName.getText());
                    Settings.getSettings().save();
                    try {
                        for (ModPack pack : ModPack.getPackArray()) {
                            if (!pack.getParentXml().equalsIgnoreCase(PrivatePackDialog.this.modpackName.getText() + ".xml")) continue;
                            FileUtils.delete(new File(OSUtils.getCacheStorageLocation(), "ModPacks/" + pack.getDir()));
                            break;
                        }
                        ModPack.removePacks(PrivatePackDialog.this.modpackName.getText() + ".xml");
                        FileUtils.delete(new File(OSUtils.getCacheStorageLocation(), "ModPacks/" + PrivatePackDialog.this.modpackName.getText() + ".xml"));
                        LaunchFrame.getInstance().modPacksPane.filterPacks();
                    }
                    catch (IOException e) {
                        Logger.logError("Error while deleting private modpack", e);
                    }
                    Logger.logInfo(PrivatePackDialog.this.modpackName.getText() + " " + I18N.getLocaleString("PRIVATEPACK_SECCESS"));
                    PrivatePackDialog.this.modpackName.setText("");
                    PrivatePackDialog.this.setVisible(false);
                } else {
                    Logger.logInfo(I18N.getLocaleString("PRIVATEPACK_NOTEXISTS"));
                }
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("PRIVATEPACK_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.editorPane = new JEditorPane();
        this.modpackName = new JTextField(16);
        this.remove = new JButton(I18N.getLocaleString("MAIN_REMOVE"));
        this.add = new JButton(I18N.getLocaleString("MAIN_ADD"));
        this.cancel = new JButton(I18N.getLocaleString("MAIN_CANCEL"));
        this.modpackName.setColumns(10);
        this.editorPane.setEditable(false);
        this.editorPane.setHighlighter(null);
        this.editorPane.setContentType("text/html");
        this.editorPane.setText(I18N.getLocaleString("PRIVATEPACK_TEXT"));
        panel.add(this.modpackName);
        panel.add(this.add);
        panel.add(this.cancel);
        panel.add(this.editorPane);
        panel.add(this.remove);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.editorPane, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.modpackName, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.add, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.remove, hSpring, "East", (Component)this.add);
        layout.putConstraint("West", (Component)this.cancel, hSpring, "East", (Component)this.remove);
        hSpring = SwingUtils.springSum(hSpring, Spring.width(this.add), Spring.constant(10), Spring.width(this.remove), Spring.constant(10), Spring.width(this.cancel));
        hSpring = Spring.max(hSpring, Spring.width(this.modpackName));
        layout.putConstraint("East", (Component)this.modpackName, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.editorPane, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        this.pack();
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.editorPane, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.editorPane), Spring.constant(5));
        layout.putConstraint("North", (Component)this.modpackName, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.modpackName), Spring.constant(10));
        layout.putConstraint("North", (Component)this.add, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.remove, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.cancel, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.height(this.add);
        rowHeight = SwingUtils.springMax(rowHeight, Spring.height(this.remove), Spring.height(this.cancel));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.modpackName.requestFocusInWindow();
        this.setLocationRelativeTo(this.getOwner());
    }
}

